# EntregaJá (MVP) — PHP + MySQL (Polling a cada 3s)

Este é um MVP **simples** focado em:
- Login (cliente/motoboy/admin)
- Criação de pedido (cliente)
- Ofertas para motoboys disponíveis (fila simples)
- Aceite/recusa de oferta (motoboy)
- Atualização de status do pedido (motoboy)
- Acompanhamento por **polling** (cliente consulta a cada 3s)

> Observação: pagamento está modelado como "direto pro motoboy" e o cliente pode marcar como "pago".

---

## Requisitos
- Windows + XAMPP (Apache + MySQL) ou equivalente
- PHP 8.0+ (recomendado)
- MySQL 5.7+ / MariaDB 10+

---

## Instalação (XAMPP no Windows)

1. **Copie a pasta do projeto**
   - Extraia este ZIP e copie a pasta `EntregaJa_MVP_PHP` para:
     - `C:\xampp\htdocs\EntregaJa_MVP_PHP`

2. **Crie o banco**
   - Abra `http://localhost/phpmyadmin`
   - Crie um banco chamado: `entregaja`
   - Selecione o banco `entregaja`
   - Importe o arquivo: `database/schema.sql`

3. **Configure o acesso ao banco**
   - Edite o arquivo: `config/config.php`
   - Ajuste usuário/senha do MySQL (por padrão no XAMPP costuma ser `root` sem senha).

4. **Acesse o sistema**
   - Abra: `http://localhost/EntregaJa_MVP_PHP/public/`

---

## Usuários de teste (seed)
O `schema.sql` já cria 3 usuários:

- **Admin**
  - email: `admin@entregaja.com`
  - senha: `admin123`

- **Cliente**
  - email: `cliente@entregaja.com`
  - senha: `cliente123`

- **Motoboy**
  - email: `motoboy@entregaja.com`
  - senha: `motoboy123`

---

## Como testar rápido

### Cliente
1. Faça login como **cliente**
2. Crie um pedido (valor + detalhes)
3. Vá em "Acompanhar pedido" para ver o polling (3s)

### Motoboy
1. Faça login como **motoboy**
2. Marque-se como **Disponível**
3. Veja a lista de ofertas e **aceite**
4. Atualize status até "entregue"

### Admin
1. Faça login como **admin**
2. Veja lista de pedidos e logs

---

## Estrutura
- `public/` — entrada do site (Apache)
- `src/` — páginas e endpoints
- `api/` — endpoints JSON usados no polling e ações
- `database/schema.sql` — tabelas e seed
- `config/` — configuração do banco

---

## Endpoints (resumo)
- `GET /api/order_status.php?order_id=ID`
- `POST /api/order_create.php`
- `POST /api/motoboy_available.php`
- `GET /api/motoboy_offers.php`
- `POST /api/offer_accept.php`
- `POST /api/offer_reject.php`
- `POST /api/order_set_status.php`

---

## Próximos passos fáceis
- Endereços com lat/lng e seleção em mapa
- Algoritmo de distância real (Haversine)
- Painel admin com filtro por status/pagamento
- Upload de comprovante/foto de entrega

Se quiser, me diga e eu implemento a próxima etapa.
