<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';

$u = require_role(['motoboy']);
$pdo = db();

// toggle disponível
$pdo->beginTransaction();
$cur = $pdo->prepare("SELECT available FROM motoboy_profiles WHERE user_id=? FOR UPDATE");
$cur->execute([$u['id']]);
$row = $cur->fetch();
if (!$row) {
  $pdo->prepare("INSERT INTO motoboy_profiles (user_id, available) VALUES (?,1)")->execute([$u['id']]);
  $available = 1;
} else {
  $available = ((int)$row['available'] === 1) ? 0 : 1;
  $pdo->prepare("UPDATE motoboy_profiles SET available=? WHERE user_id=?")->execute([$available, $u['id']]);
}
$pdo->commit();

json_out(['available'=>(bool)$available]);
