<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';

$u = require_role(['motoboy']);
$pdo = db();

// expirar ofertas vencidas
$pdo->query("UPDATE order_offers SET status='expirado' WHERE status='enviado' AND expires_at < NOW()");

// retornar ofertas ativas do motoboy
$stmt = $pdo->prepare("
  SELECT off.id AS offer_id, off.order_id, off.expires_at, o.details, o.price
  FROM order_offers off
  JOIN orders o ON o.id=off.order_id
  WHERE off.motoboy_id=? AND off.status='enviado' AND o.status IN ('procurando','ofertado')
  ORDER BY off.expires_at ASC
");
$stmt->execute([$u['id']]);
$offers = $stmt->fetchAll();

json_out(['offers'=>$offers]);
