<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';

$u = require_role(['motoboy']);
$data = post_json();
$offer_id = (int)($data['offer_id'] ?? 0);
if ($offer_id <= 0) json_out(['error'=>'offer_id inválido'], 400);

$pdo = db();
$pdo->beginTransaction();

// lock offer
$st = $pdo->prepare("SELECT * FROM order_offers WHERE id=? FOR UPDATE");
$st->execute([$offer_id]);
$off = $st->fetch();
if (!$off || (int)$off['motoboy_id'] !== (int)$u['id']) { $pdo->rollBack(); json_out(['error'=>'Oferta não encontrada'], 404); }
if ($off['status'] !== 'enviado') { $pdo->rollBack(); json_out(['error'=>'Oferta não está ativa'], 400); }
if (strtotime($off['expires_at']) < time()) {
  $pdo->prepare("UPDATE order_offers SET status='expirado' WHERE id=?")->execute([$offer_id]);
  $pdo->commit();
  json_out(['error'=>'Oferta expirada'], 400);
}

// lock order
$st = $pdo->prepare("SELECT * FROM orders WHERE id=? FOR UPDATE");
$st->execute([(int)$off['order_id']]);
$o = $st->fetch();
if (!$o) { $pdo->rollBack(); json_out(['error'=>'Pedido não encontrado'], 404); }
if (!in_array($o['status'], ['procurando','ofertado'], true)) { $pdo->rollBack(); json_out(['error'=>'Pedido não está disponível'], 400); }

// accept
$pdo->prepare("UPDATE order_offers SET status='aceito' WHERE id=?")->execute([$offer_id]);
$pdo->prepare("UPDATE orders SET motoboy_id=?, status='aceito', accepted_at=NOW() WHERE id=?")->execute([$u['id'], (int)$o['id']]);

// expire others
$pdo->prepare("UPDATE order_offers SET status='expirado' WHERE order_id=? AND id<>? AND status='enviado'")
    ->execute([(int)$o['id'], $offer_id]);

$pdo->prepare("INSERT INTO order_status_logs (order_id, status, by_user_id) VALUES (?,?,?)")
    ->execute([(int)$o['id'], 'aceito', $u['id']]);

$pdo->commit();
json_out(['ok'=>true, 'order_id'=>(int)$o['id']]);
