<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';

$u = require_role(['cliente','admin']);
$data = post_json();
$order_id = (int)($data['order_id'] ?? 0);
if ($order_id<=0) json_out(['error'=>'order_id inválido'], 400);

$pdo = db();
$pdo->beginTransaction();
$st = $pdo->prepare("SELECT * FROM orders WHERE id=? FOR UPDATE");
$st->execute([$order_id]);
$o = $st->fetch();
if (!$o) { $pdo->rollBack(); json_out(['error'=>'Pedido não encontrado'], 404); }

if ($u['role'] === 'cliente' && (int)$o['client_id'] !== (int)$u['id']) {
  $pdo->rollBack(); json_out(['error'=>'Acesso negado'], 403);
}

if ($o['payment_status'] !== 'pendente') {
  $pdo->rollBack(); json_out(['error'=>'Pagamento já está em outro estado'], 400);
}

$pdo->prepare("UPDATE orders SET payment_status='confirmado' WHERE id=?")->execute([$order_id]);
$pdo->prepare("INSERT INTO order_status_logs (order_id, status, by_user_id) VALUES (?,?,?)")
    ->execute([$order_id, 'pagamento_confirmado', $u['id']]);
$pdo->commit();
json_out(['ok'=>true]);
