<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';

$u = require_role(['cliente']);
$data = post_json();

$details = trim((string)($data['details'] ?? ''));
$price = (float)($data['price'] ?? 0);
$payment_method = $data['payment_method'] ?? 'pix';
if ($details === '' || $price <= 0) json_out(['error'=>'Dados inválidos.'], 400);
if (!in_array($payment_method, ['pix','dinheiro'], true)) $payment_method = 'pix';

$pdo = db();
$pdo->beginTransaction();

$stmt = $pdo->prepare("INSERT INTO orders (client_id, details, price, payment_method, status) VALUES (?,?,?,?, 'procurando')");
$stmt->execute([$u['id'], $details, $price, $payment_method]);
$order_id = (int)$pdo->lastInsertId();

$pdo->prepare("INSERT INTO order_status_logs (order_id, status, by_user_id) VALUES (?,?,?)")
    ->execute([$order_id, 'procurando', $u['id']]);

// Ofertar para até 5 motoboys disponíveis (fila simples)
$motoboys = $pdo->query("
  SELECT u.id 
  FROM users u
  JOIN motoboy_profiles p ON p.user_id=u.id
  WHERE u.role='motoboy' AND u.status='ativo' AND p.available=1
  ORDER BY p.total_deliveries ASC, u.id ASC
  LIMIT 5
")->fetchAll();

$expires = (new DateTime('+45 seconds'))->format('Y-m-d H:i:s');

if ($motoboys) {
  foreach ($motoboys as $m) {
    $pdo->prepare("INSERT IGNORE INTO order_offers (order_id, motoboy_id, status, expires_at) VALUES (?,?, 'enviado', ?)")
        ->execute([$order_id, (int)$m['id'], $expires]);
  }
  $pdo->prepare("UPDATE orders SET status='ofertado' WHERE id=?")->execute([$order_id]);
  $pdo->prepare("INSERT INTO order_status_logs (order_id, status, by_user_id) VALUES (?,?,?)")
      ->execute([$order_id, 'ofertado', $u['id']]);
} else {
  // sem motoboy disponível por agora, mas mantém procurando
}

$pdo->commit();

json_out(['order_id'=>$order_id]);
