<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';

$u = require_role(['motoboy']);
$data = post_json();
$order_id = (int)($data['order_id'] ?? 0);
$status = $data['status'] ?? '';
$allowed = ['a_caminho_coleta','no_local_coleta','coletado','a_caminho_entrega','entregue'];
if ($order_id<=0 || !in_array($status, $allowed, true)) json_out(['error'=>'Dados inválidos'], 400);

$pdo = db();
$pdo->beginTransaction();
$st = $pdo->prepare("SELECT * FROM orders WHERE id=? FOR UPDATE");
$st->execute([$order_id]);
$o = $st->fetch();
if (!$o) { $pdo->rollBack(); json_out(['error'=>'Pedido não encontrado'], 404); }
if ((int)$o['motoboy_id'] !== (int)$u['id']) { $pdo->rollBack(); json_out(['error'=>'Acesso negado'], 403); }

// simples: permite avançar se não estiver finalizado
if (in_array($o['status'], ['entregue','cancelado','expirado'], true)) { $pdo->rollBack(); json_out(['error'=>'Pedido finalizado'], 400); }

$pdo->prepare("UPDATE orders SET status=?".($status==='entregue' ? ", delivered_at=NOW()" : "")." WHERE id=?")
    ->execute([$status, $order_id]);

$pdo->prepare("INSERT INTO order_status_logs (order_id, status, by_user_id) VALUES (?,?,?)")
    ->execute([$order_id, $status, $u['id']]);

// incrementa entregas quando entregue
if ($status === 'entregue') {
  $pdo->prepare("UPDATE motoboy_profiles SET total_deliveries = total_deliveries + 1 WHERE user_id=?")->execute([$u['id']]);
}

$pdo->commit();
json_out(['ok'=>true]);
