<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';

$u = require_role(['cliente','motoboy','admin']);
$order_id = (int)($_GET['order_id'] ?? 0);
if ($order_id <= 0) json_out(['error'=>'order_id inválido'], 400);

$pdo = db();
$stmt = $pdo->prepare("SELECT o.*, 
  c.id AS client_id,
  m.id AS motoboy_id2, m.name AS motoboy_name, m.phone AS motoboy_phone
  FROM orders o
  JOIN users c ON c.id=o.client_id
  LEFT JOIN users m ON m.id=o.motoboy_id
  WHERE o.id=?");
$stmt->execute([$order_id]);
$o = $stmt->fetch();
if (!$o) json_out(['error'=>'Pedido não encontrado'], 404);

// autorização: cliente só vê seus pedidos; motoboy só vê se for dele; admin vê tudo
if ($u['role'] === 'cliente' && (int)$o['client_id'] !== (int)$u['id']) json_out(['error'=>'Acesso negado'], 403);
if ($u['role'] === 'motoboy' && (int)($o['motoboy_id'] ?? 0) !== (int)$u['id']) {
  // se ainda não aceitou, motoboy não deve ver detalhes por aqui
  json_out(['error'=>'Acesso negado'], 403);
}

$out = [
  'order_id' => (int)$o['id'],
  'status' => $o['status'],
  'payment_status' => $o['payment_status'],
  'payment_method' => $o['payment_method'],
  'price' => (float)$o['price'],
  'updated_at' => $o['created_at'],
  'motoboy' => null
];

if (!empty($o['motoboy_id'])) {
  $out['motoboy'] = [
    'id' => (int)$o['motoboy_id'],
    'name' => $o['motoboy_name'],
    'phone' => $o['motoboy_phone'],
  ];
}
json_out($out);
