<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';
$u = require_role(['admin']);
$pdo = db();

$order_id = (int)($_GET['order_id'] ?? 0);

$stmt = $pdo->prepare("SELECT o.*, c.name AS client_name, c.phone AS client_phone, m.name AS motoboy_name, m.phone AS motoboy_phone
                       FROM orders o
                       JOIN users c ON c.id=o.client_id
                       LEFT JOIN users m ON m.id=o.motoboy_id
                       WHERE o.id=?");
$stmt->execute([$order_id]);
$o = $stmt->fetch();
if (!$o) { echo "Pedido não encontrado."; exit; }

$logs = $pdo->prepare("SELECT l.status, l.created_at, u.name AS by_name
                       FROM order_status_logs l
                       JOIN users u ON u.id=l.by_user_id
                       WHERE l.order_id=? ORDER BY l.id ASC");
$logs->execute([$order_id]);
$logs = $logs->fetchAll();
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin - Pedido #<?= (int)$order_id ?></title>
  <style>
    body{font-family:system-ui,Arial;margin:30px;background:#f6f7fb}
    .card{background:#fff;padding:16px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08);margin-top:14px}
    table{width:100%;border-collapse:collapse}
    th,td{padding:10px;border-bottom:1px solid #eee;text-align:left}
    .muted{color:#555}
  </style>
</head>
<body>
<a href="/public/admin_orders.php">← voltar</a>

<div class="card">
  <h2>Pedido #<?= (int)$o['id'] ?></h2>
  <div><b>Cliente:</b> <?= e($o['client_name']) ?> (<?= e($o['client_phone'] ?? 'sem telefone') ?>)</div>
  <div><b>Motoboy:</b> <?= e($o['motoboy_name'] ?? '-') ?> (<?= e($o['motoboy_phone'] ?? '-') ?>)</div>
  <div><b>Status:</b> <?= e($o['status']) ?> | <b>Pagamento:</b> <?= e($o['payment_status']) ?> (<?= e($o['payment_method']) ?>)</div>
  <div><b>Valor:</b> R$ <?= number_format((float)$o['price'],2,',','.') ?></div>
  <div class="muted" style="margin-top:8px"><?= nl2br(e($o['details'])) ?></div>
</div>

<div class="card">
  <h3>Logs de status</h3>
  <table>
    <thead><tr><th>Quando</th><th>Status</th><th>Por</th></tr></thead>
    <tbody>
      <?php foreach($logs as $l): ?>
        <tr><td><?= e($l['created_at']) ?></td><td><?= e($l['status']) ?></td><td><?= e($l['by_name']) ?></td></tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
</body>
</html>
