<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';
$u = require_role(['admin']);
$pdo = db();
$rows = $pdo->query("SELECT o.id, o.status, o.payment_status, o.price, o.created_at, c.name AS client_name, m.name AS motoboy_name
                     FROM orders o
                     JOIN users c ON c.id=o.client_id
                     LEFT JOIN users m ON m.id=o.motoboy_id
                     ORDER BY o.id DESC LIMIT 100")->fetchAll();
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin - Pedidos</title>
  <style>
    body{font-family:system-ui,Arial;margin:30px;background:#f6f7fb}
    .card{background:#fff;padding:16px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08)}
    table{width:100%;border-collapse:collapse}
    th,td{padding:10px;border-bottom:1px solid #eee;text-align:left}
    a.btn{display:inline-block;padding:8px 10px;border-radius:10px;background:#111;color:#fff;text-decoration:none}
  </style>
</head>
<body>
<a href="/public/dashboard.php">← voltar</a>
<div class="card">
  <h2>Pedidos</h2>
  <table>
    <thead><tr><th>ID</th><th>Cliente</th><th>Motoboy</th><th>Status</th><th>Pagamento</th><th>Valor</th><th>Criado</th><th></th></tr></thead>
    <tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td>#<?= (int)$r['id'] ?></td>
        <td><?= e($r['client_name']) ?></td>
        <td><?= e($r['motoboy_name'] ?? '-') ?></td>
        <td><?= e($r['status']) ?></td>
        <td><?= e($r['payment_status']) ?></td>
        <td>R$ <?= number_format((float)$r['price'],2,',','.') ?></td>
        <td><?= e($r['created_at']) ?></td>
        <td><a class="btn" href="/public/admin_order_detail.php?order_id=<?= (int)$r['id'] ?>">Detalhes</a></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>
</body>
</html>
