<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
$u = require_role(['cliente']);

?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Novo pedido</title>
  <style>
    body{font-family:system-ui,Arial;margin:30px;background:#f6f7fb}
    .card{max-width:720px;background:#fff;padding:16px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08)}
    label{display:block;margin-top:12px}
    input,textarea,select{width:100%;padding:10px;border:1px solid #ddd;border-radius:10px}
    button{margin-top:16px;padding:10px 14px;border:0;border-radius:10px;cursor:pointer;background:#111;color:#fff}
    a{color:#111}
  </style>
</head>
<body>
  <a href="/public/dashboard.php">← voltar</a>
  <div class="card">
    <h2>Criar pedido</h2>
    <p>Pagamento direto pro motoboy (Pix/Dinheiro).</p>

    <form id="frm">
      <label>Detalhes do pedido</label>
      <textarea name="details" rows="4" required placeholder="Ex: Retirar documento na Rua X e levar para Rua Y..."></textarea>

      <label>Valor (R$)</label>
      <input name="price" type="number" step="0.01" min="1" required value="10.00">

      <label>Método de pagamento</label>
      <select name="payment_method">
        <option value="pix">Pix</option>
        <option value="dinheiro">Dinheiro</option>
      </select>

      <button type="submit">Solicitar motoboy</button>
    </form>

    <div id="msg" style="margin-top:12px;"></div>
  </div>

<script>
document.getElementById('frm').addEventListener('submit', async (e) => {
  e.preventDefault();
  const fd = new FormData(e.target);
  const payload = Object.fromEntries(fd.entries());
  const res = await fetch('/api/order_create.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify(payload)
  });
  const data = await res.json();
  if (!res.ok) {
    document.getElementById('msg').innerText = data.error || 'Erro.';
    return;
  }
  window.location.href = '/public/client_track.php?order_id=' + data.order_id;
});
</script>
</body>
</html>
