<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';
$u = require_role(['cliente']);
$pdo = db();
$stmt = $pdo->prepare("SELECT id, status, payment_status, price, created_at FROM orders WHERE client_id=? ORDER BY id DESC LIMIT 50");
$stmt->execute([$u['id']]);
$orders = $stmt->fetchAll();
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Meus pedidos</title>
  <style>
    body{font-family:system-ui,Arial;margin:30px;background:#f6f7fb}
    .card{background:#fff;padding:16px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08)}
    table{width:100%;border-collapse:collapse}
    th,td{padding:10px;border-bottom:1px solid #eee;text-align:left}
    a.btn{display:inline-block;padding:8px 10px;border-radius:10px;background:#111;color:#fff;text-decoration:none}
  </style>
</head>
<body>
<a href="/public/dashboard.php">← voltar</a>
<div class="card">
  <h2>Meus pedidos</h2>
  <table>
    <thead><tr><th>ID</th><th>Status</th><th>Pagamento</th><th>Valor</th><th>Criado</th><th></th></tr></thead>
    <tbody>
    <?php foreach($orders as $o): ?>
      <tr>
        <td>#<?= (int)$o['id'] ?></td>
        <td><?= e($o['status']) ?></td>
        <td><?= e($o['payment_status']) ?></td>
        <td>R$ <?= number_format((float)$o['price'],2,',','.') ?></td>
        <td><?= e($o['created_at']) ?></td>
        <td><a class="btn" href="/public/client_track.php?order_id=<?= (int)$o['id'] ?>">Acompanhar</a></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>
</body>
</html>
