<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
$u = require_role(['cliente','admin']); // admin também pode ver
$order_id = (int)($_GET['order_id'] ?? 0);
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Acompanhar pedido</title>
  <style>
    body{font-family:system-ui,Arial;margin:30px;background:#f6f7fb}
    .card{max-width:760px;background:#fff;padding:16px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08)}
    .pill{display:inline-block;padding:6px 10px;border-radius:999px;background:#eee;margin-right:6px;margin-top:6px}
    button{padding:10px 12px;border:0;border-radius:10px;background:#111;color:#fff;cursor:pointer}
  </style>
</head>
<body>
<a href="/public/dashboard.php">← voltar</a>
<div class="card">
  <h2>Pedido #<?= (int)$order_id ?></h2>
  <div id="box">
    <div class="pill">Carregando...</div>
  </div>
  <hr>
  <div>
    <button id="btnPaid" style="display:none;">Marcar como pago</button>
    <span id="paidMsg"></span>
  </div>
</div>

<script>
const orderId = <?= (int)$order_id ?>;
let timer = null;

function statusLabel(s) {
  const map = {
    novo: "Novo",
    procurando: "Procurando motoboy",
    ofertado: "Ofertas enviadas",
    aceito: "Aceito",
    a_caminho_coleta: "A caminho da coleta",
    no_local_coleta: "No local da coleta",
    coletado: "Coletado",
    a_caminho_entrega: "A caminho da entrega",
    entregue: "Entregue",
    cancelado: "Cancelado",
    expirado: "Expirado"
  };
  return map[s] || s;
}

async function poll() {
  const res = await fetch(`/api/order_status.php?order_id=${orderId}`);
  const data = await res.json();

  if (!res.ok) {
    document.getElementById('box').innerHTML = `<div class="pill">${data.error || 'Erro'}</div>`;
    return;
  }

  const mot = data.motoboy ? `${data.motoboy.name} (${data.motoboy.phone || 'sem telefone'})` : 'Aguardando';
  document.getElementById('box').innerHTML = `
    <div class="pill">Status: <b>${statusLabel(data.status)}</b></div>
    <div class="pill">Pagamento: <b>${data.payment_status}</b> (${data.payment_method})</div>
    <div class="pill">Valor: <b>R$ ${Number(data.price).toFixed(2)}</b></div>
    <div class="pill">Motoboy: <b>${mot}</b></div>
    <div class="pill">Atualizado: <b>${data.updated_at}</b></div>
  `;

  // botão "pago" aparece quando entregue e ainda pendente
  const btn = document.getElementById('btnPaid');
  if (data.status === 'entregue' && data.payment_status === 'pendente') {
    btn.style.display = 'inline-block';
  } else {
    btn.style.display = 'none';
  }

  if (['entregue','cancelado','expirado'].includes(data.status)) {
    clearInterval(timer);
    timer = null;
  }
}

document.getElementById('btnPaid').addEventListener('click', async () => {
  const res = await fetch('/api/order_confirm_payment.php', {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify({order_id: orderId})
  });
  const data = await res.json();
  document.getElementById('paidMsg').innerText = res.ok ? 'Pagamento marcado como confirmado.' : (data.error || 'Erro');
  poll();
});

(async function start() {
  await poll();
  timer = setInterval(poll, 3000);
})();
</script>
</body>
</html>
