<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
$u = require_login();
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>EntregaJá - Dashboard</title>
  <style>
    body{font-family:system-ui,Arial;margin:30px;background:#f6f7fb}
    .top{display:flex;gap:12px;align-items:center;justify-content:space-between}
    .card{background:#fff;padding:16px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08);margin-top:14px}
    a.btn{display:inline-block;padding:10px 12px;border-radius:10px;background:#111;color:#fff;text-decoration:none}
    .grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(240px,1fr));gap:12px}
  </style>
</head>
<body>
  <div class="top">
    <div>
      <h2>Olá, <?= e($u['name']) ?></h2>
      <div>Perfil: <b><?= e($u['role']) ?></b></div>
    </div>
    <a class="btn" href="/public/logout.php">Sair</a>
  </div>

  <div class="grid">
    <?php if ($u['role'] === 'cliente'): ?>
      <div class="card">
        <h3>Cliente</h3>
        <p>Criar e acompanhar pedidos.</p>
        <a class="btn" href="/public/client_create_order.php">Criar pedido</a>
        <a class="btn" href="/public/client_orders.php" style="margin-left:8px;background:#444">Meus pedidos</a>
      </div>
    <?php elseif ($u['role'] === 'motoboy'): ?>
      <div class="card">
        <h3>Motoboy</h3>
        <p>Ficar disponível e aceitar ofertas.</p>
        <a class="btn" href="/public/motoboy_panel.php">Painel do motoboy</a>
      </div>
    <?php else: ?>
      <div class="card">
        <h3>Admin</h3>
        <p>Ver pedidos e auditoria.</p>
        <a class="btn" href="/public/admin_orders.php">Ver pedidos</a>
      </div>
    <?php endif; ?>
  </div>

</body>
</html>
