<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = trim($_POST['email'] ?? '');
  $pass = $_POST['password'] ?? '';
  if (login($email, $pass)) {
    header('Location: /public/dashboard.php');
    exit;
  }
  $error = 'Login inválido.';
}
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>EntregaJá - Login</title>
  <style>
    body{font-family:system-ui,Arial;margin:40px;background:#f6f7fb}
    .card{max-width:420px;background:#fff;padding:20px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08)}
    label{display:block;margin-top:12px}
    input{width:100%;padding:10px;border:1px solid #ddd;border-radius:10px}
    button{margin-top:16px;padding:10px 14px;border:0;border-radius:10px;cursor:pointer}
    .err{color:#b00020;margin-top:10px}
    .hint{color:#555;font-size:14px;margin-top:12px}
  </style>
</head>
<body>
  <div class="card">
    <h2>EntregaJá</h2>
    <p>Login</p>
    <?php if ($error): ?><div class="err"><?= e($error) ?></div><?php endif; ?>
    <form method="post">
      <label>Email</label>
      <input name="email" type="email" required>
      <label>Senha</label>
      <input name="password" type="password" required>
      <button type="submit">Entrar</button>
    </form>
    <div class="hint">
      Seeds (teste):<br>
      admin@entregaja.com / admin123<br>
      cliente@entregaja.com / cliente123<br>
      motoboy@entregaja.com / motoboy123
    </div>
  </div>
</body>
</html>
