<?php
session_start();
require_once __DIR__ . '/../src/lib/auth.php';
require_once __DIR__ . '/../src/lib/helpers.php';
require_once __DIR__ . '/../src/lib/db.php';
$u = require_role(['motoboy']);
$pdo = db();

$stmt = $pdo->prepare("SELECT available FROM motoboy_profiles WHERE user_id=?");
$stmt->execute([$u['id']]);
$profile = $stmt->fetch();
$available = $profile ? (int)$profile['available'] : 0;
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Painel do motoboy</title>
  <style>
    body{font-family:system-ui,Arial;margin:30px;background:#f6f7fb}
    .card{max-width:900px;background:#fff;padding:16px;border-radius:12px;box-shadow:0 6px 20px rgba(0,0,0,.08);margin-top:14px}
    button{padding:10px 12px;border:0;border-radius:10px;background:#111;color:#fff;cursor:pointer}
    table{width:100%;border-collapse:collapse}
    th,td{padding:10px;border-bottom:1px solid #eee;text-align:left}
    .muted{color:#555}
  </style>
</head>
<body>
<a href="/public/dashboard.php">← voltar</a>

<div class="card">
  <h2>Motoboy: <?= e($u['name']) ?></h2>
  <div class="muted">Status: <b id="availLabel"><?= $available ? 'Disponível' : 'Indisponível' ?></b></div>
  <button id="btnToggle"><?= $available ? 'Ficar indisponível' : 'Ficar disponível' ?></button>
  <span id="msg"></span>
</div>

<div class="card">
  <h3>Ofertas (atualiza a cada 3s)</h3>
  <div class="muted">Aceite antes de expirar.</div>
  <table>
    <thead><tr><th>Pedido</th><th>Detalhes</th><th>Valor</th><th>Expira</th><th>Ação</th></tr></thead>
    <tbody id="offers"></tbody>
  </table>
</div>

<div class="card">
  <h3>Pedido ativo</h3>
  <div id="active">Carregando...</div>
</div>

<script>
let timer = null;

async function refreshOffers() {
  const res = await fetch('/api/motoboy_offers.php');
  const data = await res.json();
  if (!res.ok) return;

  const tbody = document.getElementById('offers');
  tbody.innerHTML = '';
  for (const o of data.offers) {
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td>#${o.order_id}</td>
      <td>${o.details}</td>
      <td>R$ ${Number(o.price).toFixed(2)}</td>
      <td>${o.expires_at}</td>
      <td>
        <button onclick="acceptOffer(${o.offer_id})">Aceitar</button>
        <button onclick="rejectOffer(${o.offer_id})" style="background:#444;margin-left:6px">Recusar</button>
      </td>
    `;
    tbody.appendChild(tr);
  }
}

async function refreshActive() {
  const res = await fetch('/api/motoboy_active_order.php');
  const data = await res.json();
  const box = document.getElementById('active');
  if (!res.ok) { box.innerText = data.error || 'Erro'; return; }

  if (!data.order) {
    box.innerHTML = '<span class="muted">Nenhum pedido ativo.</span>';
    return;
  }
  const o = data.order;
  box.innerHTML = `
    <div><b>Pedido #${o.id}</b> — Status: <b>${o.status}</b> — Valor: <b>R$ ${Number(o.price).toFixed(2)}</b></div>
    <div class="muted">${o.details}</div>
    <div style="margin-top:10px">
      <button onclick="setStatus(${o.id}, 'a_caminho_coleta')">A caminho coleta</button>
      <button onclick="setStatus(${o.id}, 'no_local_coleta')" style="background:#444;margin-left:6px">No local</button>
      <button onclick="setStatus(${o.id}, 'coletado')" style="background:#444;margin-left:6px">Coletado</button>
      <button onclick="setStatus(${o.id}, 'a_caminho_entrega')" style="background:#444;margin-left:6px">A caminho entrega</button>
      <button onclick="setStatus(${o.id}, 'entregue')" style="background:#0b5;margin-left:6px">Entregue</button>
    </div>
  `;
}

async function acceptOffer(offerId) {
  const res = await fetch('/api/offer_accept.php', {
    method:'POST', headers:{'Content-Type':'application/json'},
    body: JSON.stringify({offer_id: offerId})
  });
  await refreshOffers();
  await refreshActive();
}

async function rejectOffer(offerId) {
  const res = await fetch('/api/offer_reject.php', {
    method:'POST', headers:{'Content-Type':'application/json'},
    body: JSON.stringify({offer_id: offerId})
  });
  await refreshOffers();
}

async function setStatus(orderId, status) {
  const res = await fetch('/api/order_set_status.php', {
    method:'POST', headers:{'Content-Type':'application/json'},
    body: JSON.stringify({order_id: orderId, status})
  });
  await refreshActive();
}

document.getElementById('btnToggle').addEventListener('click', async () => {
  const res = await fetch('/api/motoboy_available.php', {
    method:'POST', headers:{'Content-Type':'application/json'},
    body: JSON.stringify({})
  });
  const data = await res.json();
  if (res.ok) {
    document.getElementById('availLabel').innerText = data.available ? 'Disponível' : 'Indisponível';
    document.getElementById('btnToggle').innerText = data.available ? 'Ficar indisponível' : 'Ficar disponível';
  }
});

(async function start(){
  await refreshOffers();
  await refreshActive();
  timer = setInterval(async () => {
    await refreshOffers();
    await refreshActive();
  }, 3000);
})();
</script>
</body>
</html>
