<?php
// src/lib/auth.php
require_once __DIR__ . '/db.php';

function require_login() : array {
  if (!isset($_SESSION['user'])) {
    header('Location: /public/login.php');
    exit;
  }
  return $_SESSION['user'];
}

function require_role(array $roles) : array {
  $u = require_login();
  if (!in_array($u['role'], $roles, true)) {
    http_response_code(403);
    echo "Acesso negado.";
    exit;
  }
  return $u;
}

function login(string $email, string $password) : bool {
  $pdo = db();
  $stmt = $pdo->prepare("SELECT id, name, email, password_hash, role, status FROM users WHERE email = ?");
  $stmt->execute([$email]);
  $u = $stmt->fetch();
  if (!$u) return false;
  if ($u['status'] !== 'ativo') return false;
  if (!password_verify($password, $u['password_hash'])) return false;

  unset($u['password_hash']);
  $_SESSION['user'] = $u;
  return true;
}

function logout() : void {
  unset($_SESSION['user']);
}
