<?php
// src/lib/helpers.php
function e(string $s) : string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function json_out($data, int $code = 200) : void {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_UNICODE);
  exit;
}

function post_json() : array {
  $raw = file_get_contents('php://input');
  $data = json_decode($raw, true);
  return is_array($data) ? $data : $_POST;
}
